<?php 

function SexCaseFamily($name) 
{
    $name = trim($name);
    
    $female = 0;
    $male = 0;
    
    if (preg_match("/^([А-я]+)$/ui", $name)) {
        $delimiter = -2;
    } else {
        $delimiter = -1;
    }
    
    $s = substr($name, $delimiter);
    
    // Шаблон женских окончаний
    $f = array(
        'ова','ева','кая','ина','ная','лис','ына','ька','вич','гер',
        'нюк','ких','лер','ман','нко','лэп','тер','зен','йер','арь',
        'сон','няк','вец','шер','ерг','чук','ник','ица','лых','нак',
        'йко','сад','жус','пян','гай','ким','ена',
        
    );
    
    $f2 = array(
        'ва','ая','на','ис','ка','ич','ер','юк','их','ан','ко','эп',
        'ен','он','рь','ец','як','ук','рг','ик','ак','ца','ых','ад',
        'ус','ян','ай','им','ня',
    );
    
    $f3 = array(
        'нова','рова','кова','мова','пова','цова','еева','лова','аева',
        'иева','ская','ьева','хова','сова','това','лина','цкая','тева',
        'цева','рина','кина','зова','гина','сина','дова','мина','шина',
        'бная','фина','чная','нина','хина','улис','цына','жина','жная',
        'ська','лева','ович','ргер','дких','длер','енюк','фман','енко',
        'нтер','узен','айер','тарь','ьсон','ских','авец','зняк','барь',
        'ишер','берг','ичук','дник','ница','хнюк','алых','снак','евич',
        'ойко','анюк','ьчук','мчук','осад','опян','шена',
    );
    
    $f4 = array(
        'ова',
    );
    
    // Шаблон мужских окончаний
    $m = array(
        'нов','иев','дов','ков','ров','аев','лый','цов','лов','пов',
        'мин','мов','хов','ный','уев','сев','нин','кий','рев','вой',
        'тов','дев','еев','тин','шев','лин','хин','зов','лев','вич',
        'дин','кин','жов','пин','гин','пыч','щан','ний','ота','ныч',
        'лыч','бин','олк','рин','нко','руз','гез','чий','лян','орм',
        'шко','рит','оик','нук','уча','тор','жян','йлы','ько','чун',
        'бек','йко','ало','рут','люк','тых','ман','роз','нян','тас',
        'кян','чук','ава','ейх','лик','еля','рли','мец','жак','есь',
        'чиц','пян','Цуй','арь','рко','тус','пко','кан','тян','пиц',
        'чак','ида','нси','ран','ций','иша','дах','ент','цун','зак',
        'гай','ким',
    );
    
    $m2 = array(
        'ов','ев','ый','ин','ий','ой','ич','ыч','та','лк','ко','нт',
        'ез','уз','ян','рм','ит','ик','ча','ук','ор','лы','ун','юк',
        'ых','ек','ло','ут','оз','ас','ва','йх','ля','ли','ец','ак',
        'сь','иц','рь','уй','ус','си','да','ах','ша','ай','им','ня',
    );
    
    $m3 = array(
        'анов','лиев','едов','яков','тров','рнов','лаев','елый','ецов',
        'аров','илов','вцов','елов','иров','ыдов','ппов','онов','омин',
        'амов','алов','ухов','ский','усев','инин','чный','раев','арев',
        'отов','имов','едев','леев','рков','сеев','евой','аков','янов',
        'итин','илин','ухин','яхин','ынов','утов','сков','атов','инов',
        'изов','плов','ышев','влев','феев','евич','лдин','идов','еров',
        'укин','иков','узов','ллин','ьков','рный','шкин','акин','ыжов',
        'дков','мный','итов','ткин','овой','юпин','ушев','цкий','олев',
        'джов','уров','шков','Ежов','нков','удин','ипов','енов','каев',
        'ятин','юков','деев','агин','ович','таев','апыч','ещан','жний',
        'сота','аныч','скин','алыч','убин','орин','енко','игез','учий',
        'еков','алян','ишко','джян','вчун','айлы','дько','нтор','ойко',
        'нбин','ыбек','кало','юлюк','ютых','прут','рман','ороз','кман',
        'анян','пало','ртас','сько','акян','ьчук','нава','илик','теля',
        'ерли','имец','ожак','опян','несь','учиц','парь','лько','урко',
        'лтус','упко','укан','етян','един','ький','гида','ипко','анси',
        'нчак','аран','аций','ниша','лков','вдах','рцун','гент','бзак',
    );
    
    $q = substr($name, $delimiter * 3);
    $q2 = substr($name, $delimiter * 2);
    $q3 = substr($name, $delimiter * 4);
    
    // Проверка женской фамилии по шаблону
    if (in_array($q3, $f3) && strlen2($name) > 5) {
        $female += 4;
    }
    if (in_array($q, $f) && strlen2($name) > 5) {
        $female += 3;
    }
    if (in_array($q2, $f2) && strlen2($name) > 4) {
        $female += 2;
    }
    if (in_array($q, $f4) && strlen2($name) > 6) {
        $female += 3;
    }
    
    // Проверка мужской фамилии по шаблону
    if (in_array($q3, $m3) && strlen2($name) > 5) {
        $male += 4;
    }
    if (in_array($q, $m) && strlen2($name) > 5) {
        $male += 3;
    }
    if (in_array($q2, $m2) && strlen2($name) > 4) {
        $male += 2;
    }
    
    if ($female >= $male) {
        $sex = '0';
    } else {
        $sex = '1';
    }
    
    return array(
        'result' => $sex, 
        'female' => $female, 
        'male' => $male, 
        'count' => ($male + $female), 
        'text' => $name, 
        'type' => 'ank_family', 
    );
}


function SexCaseName($name) 
{
    $name = trim($name);
    
    $female = 0;
    $male = 0;
    
    if (preg_match("/^([А-яё]+)$/ui", $name)) {
        $delimiter = -2;
    } else {
        $delimiter = -1;
    }
    
    $s = substr($name, $delimiter);
    
    
    // Шаблон женских окончаний
    $f = array(
        'сия','лия','ина','ена','нна','рия','ьга','яна','лья','ана',
        'атя','рья','стя','ния','дра','аня','аша','жда','ила','еся',
        'юша','ика','ита','иза','ера','ета','иса','шка','тка','овь',
        'адя','юта','лла','ира','оня','чка','нка','лсу','юда','ада',
        'ька','аля','юба','иля','рим','иша','тта','еля','уля','тая',
        'ева','аря','уня','дия','дир','има','она','рка','хра','сан',
        'юня','юха','мия','яша','ата','ася','ося','мия','ине','мин',
        'дже','фия','ора','еша','ара','наз','ава','еня','фья','уль',
        'ела','оля'
    );
    
    $f2 = array(
        'ия','на','га','ья','тя','ра','ня','ля','ша','да','ла','ся',
        'ка','та','за','са','вь','дя','су','ба','им','ва','ая','ря',
        'ир','ма','ан','ха','не','ин','же','аз','ль','ур','лю','ли',
        'то','ни','йя','ес','оя','ик','ок',
    );
    
    // Шаблон мужских окончаний
    $m = array(
        'ндр','рей','гей','рий','сей','сим','ний','нис','ита','тон',
        'има','орь','лья','ван','лег','ман','лад','мир','илл','аил',
        'акс','вел','лан','аша','лав','лай','лий','дим','гор','аня',
        'ома','тур','тор','ова','еня','юра','мур','иша','оля','нил',
        'ега','иил','ава','дан','тин','тас','дор','стя','рат','там',
        'лик','ера','еха','етя','итя','рас','зар','ард','одя','юха',
        'мон','ена','тем','иль','дик','вин','наз','мид','мик','ася',
        'иха','рын','вер','дин','хам','ерт','мал','дос','иан','сур',
        'ипп','шат','зан','ано','ган','лим','риз','кич','рам','хан',
        'етр','ляс','рио','хун','бек','ияр','мил','рка','мар','лоз',
        'рый','чик','льд','лен','еша','Ник','кси','тий','нур','гий',
        'арк','ька','сан','леб','ека','вид','нид','пан','ила','сто',
        'дар','лый','мий','едя','рик','екс','лют','вик','рис','дий',
        'сен','оис','афо','мка','лыч','фей','мат','нат','нек','дам',
        'ёма','ема',
    );
    
    $m2 = array(
        'др','ей','ий','им','ис','та','он','ма','рь','ья','ан','ег',
        'ад','ир','лл','ил','кс','ел','ша','ав','ор','ня','ур','ал',
        'ва','ра','ля','га','ин','ас','тя','ат','ам','ик','ха','ар',
        'рд','дя','на','ем','ль','аз','ид','ся','ын','ер','рт',
    );
    
    $q = substr($name, $delimiter * 3);
    $q2 = substr($name, $delimiter * 2);
    
    // Проверка женского имени по шаблону
    if (in_array($q, $f)) {
        $female += 2;
        if (strlen2($name) <= 6) {
            $female++;
        }
    }
    if (in_array($q2, $f2)) {
        $female += 1;
    }
    
    // Проверка мужского имени по шаблону
    if (in_array($q, $m)) {
        $male += 2;
        if (strlen2($name) <= 6) {
            $male++;
        }
    }
    if (in_array($q2, $m2)) {
        $male += 1;
    }
    
    if ($female >= $male) {
        $sex = '0';
    } else {
        $sex = '1';
    }
    
    return array(
        'result' => $sex, 
        'female' => $female, 
        'male' => $male, 
        'count' => ($male + $female), 
        'text' => $name, 
        'type' => 'ank_name', 
    );
}


function SexCase($param1, $param2) {
    $is_name[0] = SexCaseName($param1); 
    $is_name[1] = SexCaseFamily($param1); 
    
    $is_name[2] = SexCaseName($param2); 
    $is_name[3] = SexCaseFamily($param2); 
    
    $name = 0;
    $surname = 0;
    
    if ($is_name[0]['count'] > $is_name[1]['count']) {
        $name++; 
    } 
    if ($is_name[1]['count'] > $is_name[0]['count']) {
        $surname++;
    }
    
    if ($is_name[2]['count'] > $is_name[3]['count']) {
        $surname++; 
    } 
    if ($is_name[3]['count'] > $is_name[2]['count']) {
        $name++;
    }
    
    if ($is_name[0]['count'] > $is_name[2]['count']) {
        $name++; 
    } 
    if ($is_name[2]['count'] > $is_name[0]['count']) {
        $surname++; 
    } 
    
    if ($name > $surname) {
        return array(
            'first_name' => $param1,
            'last_name' => $param2,
            'gender' => $is_name[3]['result'],
        );
    } else {
        return array(
            'first_name' => $param2,
            'last_name' => $param1,
            'gender' => $is_name[1]['result'],
        );
    }
}

function SexCaseOne($param) {
    $is_name[0] = SexCaseName($param); 
    $is_name[1] = SexCaseFamily($param); 
    
    if ($is_name[0]['count'] > $is_name[1]['count']) {
        $i = 0;
    } else {
        $i = 1;
    }
    
    return array(
        'text' => $param,
        'type' => $is_name[$i]['type'],
        'gender' => $is_name[$i]['result'],
    );
}